/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.server.create;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.network.ShopNetwork;
import net.sixik.sdmshoprework.network.client.SyncShopS2C;

public class SendCreateShopEntryC2S
extends BaseC2SMessage {
    private final UUID tabID;
    private final CompoundTag nbt;

    public SendCreateShopEntryC2S(UUID tabID, CompoundTag nbt) {
        this.nbt = nbt;
        this.tabID = tabID;
    }

    public SendCreateShopEntryC2S(FriendlyByteBuf nbt) {
        this.nbt = nbt.m_130261_();
        this.tabID = nbt.m_130259_();
    }

    public MessageType getType() {
        return ShopNetwork.CREATE_SHOP_ENTRY;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130079_(this.nbt);
        friendlyByteBuf.m_130077_(this.tabID);
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        try {
            ShopTab shopTab = ShopBase.SERVER.getShopTab(this.tabID);
            ShopEntry shopEntry = new ShopEntry(shopTab);
            shopEntry.deserializeNBT(this.nbt);
            shopTab.getTabEntry().add(shopEntry);
            new SyncShopS2C(ShopBase.SERVER.serializeNBT()).sendToAll(packetContext.getPlayer().m_20194_());
            ShopBase.SERVER.saveShopToFile();
        }
        catch (Exception e) {
            SDMShopRework.printStackTrace("", e);
        }
    }
}

